//
//  CRTwoWayBindingManager.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 3/4/10.
//  Copyright 2010 Corner-A. All rights reserved.
//


extern NSString* const CRWantsTwoWayBinding;

/////////////////////////////////////////////////////////////////////
// Hand-made replacement for a NSDictionary to avoid retaining
// binding target
/////////////////////////////////////////////////////////////////////
@interface CRBindingInfo : NSObject
{
	id assigned			controller;
	NSString*			keyPath;
	NSString*			transformerName;
	NSValueTransformer*	transformer;
}

@property (assign, nonatomic, readonly) id controller;
@property (strong, nonatomic, readonly) NSString* keyPath;
@property (strong, nonatomic, readonly) NSValueTransformer*	transformer;

- (id)initWithController:(id)aController keyPath:(NSString *)aKeyPath options:(NSDictionary *)options;
+ (id)infoWithController:(id)aController keyPath:(NSString *)aKeyPath options:(NSDictionary *)options;

@end

/////////////////////////////////////////////////////////////////////
// CRTwoWayBindingManager
/////////////////////////////////////////////////////////////////////
@interface CRTwoWayBindingManager : NSObject 
{
@private
	id assigned			 root;
	NSMutableSet*		 acceptsEqual;
	NSMutableDictionary* twoWayBindings;
	NSMutableDictionary* preventRecursion;
}

@property (nonatomic, readonly) NSMutableSet* acceptsEqual;

- (void)bind:(NSString *)bindingName toObject:(id)observableController withKeyPath:(NSString *)keyPath options:(NSDictionary *)options;
- (void)unbind:(NSString*)bindingName;

- (id)initWithObject:(id)object;

@end